# Generated Python Strategy for: PlayerA (meta)
# Run Index: 9
# Primary LLM: DeepSeek-V3 (deepseek-ai/DeepSeek-V3-0324) Provider: novita
def PlayerA_DeepSeek_V3_MetaAgent_Run9_Iter0(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # First move: Cooperate to start friendly
    if not my_history:
        return "C"
    
    # Heuristic analysis of opponent's code
    opponent_code = opponent_program_code.lower()
    
    # Check for always_cooperate or similar patterns
    always_cooperate_phrases = [
        "always cooperate",
        "return 'c'",
        "return c",
        "return 'c'",
        "return 'cooperate'",
        "return cooperate",
    ]
    if any(phrase in opponent_code for phrase in always_cooperate_phrases):
        return "C"
    
    # Check for always_defect or similar patterns
    always_defect_phrases = [
        "always defect",
        "return 'd'",
        "return d",
        "return 'd'",
        "return 'defect'",
        "return defect",
    ]
    if any(phrase in opponent_code for phrase in always_defect_phrases):
        return "D"
    
    # Check for Tit-for-Tat-like behavior (checking last move)
    tit_for_tat_phrases = [
        "opp_history[-1]",
        "opp_history[len(opp_history)-1]",
        "opp_history[ -1 ]",
        "opp_history[ - 1 ]",
    ]
    if any(phrase in opponent_code for phrase in tit_for_tat_phrases):
        return opp_history[-1] if opp_history else "C"
    
    # Check for random behavior
    random_phrases = [
        "random.choice",
        "random.choose",
        "random.randint",
        "random.random",
    ]
    if any(phrase in opponent_code for phrase in random_phrases):
        return "D"  # Defect against random players
    
    # Check for code length (very short code might be simple strategies)
    if len(opponent_program_code) < 50:
        return "C"  # Assume simple strategies are cooperative
    
    # Default to Tit-for-Tat if no clear pattern is found
    return opp_history[-1] if opp_history else "C"